% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanjivec.R
\name{get_strokes_compo}
\alias{get_strokes_compo}
\title{Get the strokes of a specific component of a kanjivec object}
\usage{
get_strokes_compo(kvec, which = c(1, 1))
}
\arguments{
\item{kvec}{an object of class \code{kanjivec}}

\item{which}{a vector of length 2 specifing the index of the component, i.e. the component used
is \code{pluck(kvec$components, !!!which)}. The default \code{c(1,1)} refers
to the root component (full kanji), so all strokes are returned.}
}
\value{
A list of strokes with attributes.
}
\description{
The strokes are the leaves of the kanjivec \code{stroketree}. They consist of
a two-column matrix giving a discretized path for the stroke in the unit square \eqn{[0,1]^2}
with further attributes.
}
\examples{
kanji <- fivebetas[[5]]
# get the three strokes of the component\u2ed6 in \u9663
rad <- get_strokes_compo(kanji, c(2,1))    
plot(0.5, 0.5, xlim=c(0,1), ylim=c(0,1), type="n", asp=1, xaxs="i", yaxs="i", xlab="", ylab="")
invisible(lapply(rad, lines, lwd=4))

}
\seealso{
\code{\link{get_strokes}}
}
