% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{archtest}
\alias{archtest}
\title{ARCH Test}
\usage{
archtest(resid, q = 1)
}
\arguments{
\item{resid}{The residuals of the model}

\item{q}{max lag}
}
\value{
A list of class "kardl" containing the following components:
\itemize{
\item type: Type of the test
\item statistic: The F-statistic of the test
\item parameter: The degrees of freedom of the test
\item p.value: The p-value of the test
\item Fval: The F-value of the test
 }
}
\description{
Autoregressive conditional heteroskedasticity ARCH(q) \deqn{{\hat{\epsilon}}_t^2 = \alpha_0 + \sum_{i=1}^{q} \alpha_i {\hat{\epsilon}}_{t-i}^2}
}
\examples{

kardl_model<-kardl(imf_example_data,
                   CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                   mode=c(1,2,3,0))
archtest(kardl_model$finalModel$model$residuals,2)


# Summary of ARCH test
summary(archtest(kardl_model$finalModel$model$residuals))
}
\references{
Engle, Robert F. (1982). Autoregressive Conditional Heteroskedasticity with Estimates of the Variance of United Kingdom Inflation. Econometrica. 50 (4): 987–1007.
}
\seealso{
\code{\link[lmtest]{bgtest}} \code{\link[lmtest]{bptest}}  \code{\link[lmtest]{resettest}}
}
