% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianMixtureCalls.R
\name{plotCopyNumberGMM}
\alias{plotCopyNumberGMM}
\title{Plot copy number GMM components}
\usage{
plotCopyNumberGMM(
  TapestriExperiment,
  feature.id = 1,
  chromosome.scope = "chr",
  draw.boundaries = FALSE
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object.}

\item{feature.id}{chromosome or chromosome arm to plot.}

\item{chromosome.scope}{"chr" or "arm", for plotting models for either whole chromosomes or chromosome arms.}

\item{draw.boundaries}{logical, if \code{TRUE}, draw decision boundaries between each Gaussian component.}
}
\value{
\code{ggplot} object, density plot
}
\description{
Plots the probability densities of GMM components for given chromosome or chromosome arm, store in a \code{TapestriExperiment}.
\code{\link[=calcGMMCopyNumber]{calcGMMCopyNumber()}} must be run first.
}
\examples{
\donttest{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- calcNormCounts(tap.object)
control.copy.number <- generateControlCopyNumberTemplate(tap.object,
  copy.number = 2,
  sample.feature.label = "cellline1"
)
tap.object <- calcCopyNumber(tap.object,
  control.copy.number,
  sample.feature = "test.cluster"
)
tap.object <- calcSmoothCopyNumber(tap.object)
tap.object <- calcGMMCopyNumber(tap.object,
  cell.barcodes = colnames(tap.object),
  control.copy.number = control.copy.number,
  model.components = 1:5
)

tap.object <- plotCopyNumberGMM(tap.object,
  feature.id = 7,
  chromosome.scope = "chr",
  draw.boundaries = TRUE
)
}
}
\concept{copy number}
\concept{plots}
