% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{image_data_generator}
\alias{image_data_generator}
\title{\link{Deprecated} Generate batches of image data with real-time data augmentation.
The data will be looped over (in batches).}
\usage{
image_data_generator(
  featurewise_center = FALSE,
  samplewise_center = FALSE,
  featurewise_std_normalization = FALSE,
  samplewise_std_normalization = FALSE,
  zca_whitening = FALSE,
  zca_epsilon = 1e-06,
  rotation_range = 0,
  width_shift_range = 0,
  height_shift_range = 0,
  brightness_range = NULL,
  shear_range = 0,
  zoom_range = 0,
  channel_shift_range = 0,
  fill_mode = "nearest",
  cval = 0,
  horizontal_flip = FALSE,
  vertical_flip = FALSE,
  rescale = NULL,
  preprocessing_function = NULL,
  data_format = NULL,
  validation_split = 0
)
}
\arguments{
\item{featurewise_center}{Set input mean to 0 over the dataset, feature-wise.}

\item{samplewise_center}{Boolean. Set each sample mean to 0.}

\item{featurewise_std_normalization}{Divide inputs by std of the dataset,
feature-wise.}

\item{samplewise_std_normalization}{Divide each input by its std.}

\item{zca_whitening}{apply ZCA whitening.}

\item{zca_epsilon}{Epsilon for ZCA whitening. Default is 1e-6.}

\item{rotation_range}{degrees (0 to 180).}

\item{width_shift_range}{fraction of total width.}

\item{height_shift_range}{fraction of total height.}

\item{brightness_range}{the range of brightness to apply}

\item{shear_range}{shear intensity (shear angle in radians).}

\item{zoom_range}{amount of zoom. if scalar z, zoom will be randomly picked
in the range \verb{[1-z, 1+z]}. A sequence of two can be passed instead to
select this range.}

\item{channel_shift_range}{shift range for each channels.}

\item{fill_mode}{One of "constant", "nearest", "reflect" or "wrap". Points
outside the boundaries of the input are filled according to the given mode:
\itemize{
\item "constant": \code{kkkkkkkk|abcd|kkkkkkkk} (\code{cval=k})
\item "nearest":  \code{aaaaaaaa|abcd|dddddddd}
\item "reflect":  \code{abcddcba|abcd|dcbaabcd}
\item "wrap":     \code{abcdabcd|abcd|abcdabcd}
}}

\item{cval}{value used for points outside the boundaries when fill_mode is
'constant'. Default is 0.}

\item{horizontal_flip}{whether to randomly flip images horizontally.}

\item{vertical_flip}{whether to randomly flip images vertically.}

\item{rescale}{rescaling factor. If NULL or 0, no rescaling is applied,
otherwise we multiply the data by the value provided (before applying any
other transformation).}

\item{preprocessing_function}{function that will be implied on each input.
The function will run before any other modification on it. The function
should take one argument: one image (tensor with rank 3), and should output
a tensor with the same shape.}

\item{data_format}{'channels_first' or 'channels_last'. In 'channels_first'
mode, the channels dimension (the depth) is at index 1, in 'channels_last'
mode it is at index 3. It defaults to the \code{image_data_format} value found
in your Keras config file at \verb{~/.keras/keras.json}. If you never set it,
then it will be "channels_last".}

\item{validation_split}{fraction of images reserved for validation (strictly
between 0 and 1).}
}
\description{
Deprecated: \code{image_data_generator} is not
recommended for new code. Prefer loading images with
\code{image_dataset_from_directory} and transforming the output
TF Dataset with preprocessing layers. For more information, see the
tutorials for loading images and augmenting images, as well as the
preprocessing layer guide.
}
