% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_one_hot}
\alias{k_one_hot}
\title{Computes the one-hot representation of an integer tensor.}
\usage{
k_one_hot(indices, num_classes)
}
\arguments{
\item{indices}{nD integer tensor of shape \verb{(batch_size, dim1, dim2, ... dim(n-1))}}

\item{num_classes}{Integer, number of classes to consider.}
}
\value{
(n + 1)D one hot representation of the input with shape
\verb{(batch_size, dim1, dim2, ... dim(n-1), num_classes)}
}
\description{
Computes the one-hot representation of an integer tensor.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

