% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{model_exists}
\alias{model_exists}
\title{Check if a Kerasnip Model Specification Exists}
\usage{
model_exists(model_name)
}
\arguments{
\item{model_name}{A character string giving the name of the model
specification function to check (e.g., "my_mlp").}
}
\value{
A logical value, \code{TRUE} if the model exists, \code{FALSE} otherwise.
}
\description{
This is an internal helper function to check if a model specification has been
registered in the \code{parsnip} model environment.
}
\examples{
\donttest{
if (requireNamespace("parsnip", quietly = TRUE)) {
  library(parsnip)

  # Check for a model that exists in parsnip
  model_exists("mlp")

  # Check for a model that does not exist
  model_exists("non_existent_model")
}
}
}
\keyword{internal}
