% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/khazard.R
\name{khazard}
\alias{khazard}
\title{Kernel estimate of hazard function for right-censored data}
\usage{
khazard(times, delta, h = NULL, t = NULL, t.length = 100,
  tmin = NULL, tmax = NULL, kernel = "epanechnikov",
  type = "interior", parallel = FALSE, value = "CVML",
  h.method = "crossval", optim.method = "optimize",
  tol = ifelse(h.method == "crossval", 10^(-6), 1), run = 2, ...)
}
\arguments{
\item{times}{vector of observed times}

\item{delta}{vector of censoring indicator. 0 - censored, 1 - uncensored (dead)}

\item{h}{bandwidth (scalar or vector). If missing, h is found using some bandwidth selection method.}

\item{t}{vector of time points at which estimate is evaluated}

\item{t.length}{number of grid points}

\item{tmin, tmax}{minimum/maximum values for grid}

\item{kernel}{kernel function, possible values are: "epanechnikov" (default), "gaussian", "rectangular", "quartic".}

\item{type}{Type of kernel estimate. Possible types are:  "exterior", "interior" (default).}

\item{parallel}{allows parallel computation. Default is FALSE.}

\item{value}{If h parameter is vector, this option controls output values. If "CVML" (default), the crossvalidation or log-likelihood values only are calculated. If "hazard", the hazard functions only are calculated. If "both" the crossvalidation or log-likelihood values and hazard function are calculated.}

\item{h.method}{method for bandwidth selection. Possible methods are: "crossval" (default), "maxlike".}

\item{optim.method}{method for numerical optimization of the crossvalidation or log-likelihood function. Possible methods are: "optimize" (default), "ga".}

\item{tol}{the desired accuracy of optimization algorithm}

\item{run}{the number of consecutive generations without any improvement in the best fitness value before the GA is stopped.}

\item{...}{additional arguments of GA algorithm}
}
\value{
Returns an object of class 'khazard' which is a list with fields
\item{time.points}{vector of time points at which estimate is evaluated}
\item{hazard}{data frame of time points, hazard function values and bandwidth}
\item{h}{bandwidth}
\item{CVML}{value of crossvalidation or log-likelihood at h}
\item{details}{description of used methods}
\item{GA.result}{output of ga, object of class ga-class}
}
\description{
Kernel estimate of (unconditional) hazard function for right-censored data. Options include two methods for bandwidth selection.
}
\details{
External type of kernel estimator is defined as the ratio of kernel estimator of the subdensity of the uncensored observations to the survival function of the observable time. Internal type of kernel estimator is based on a convolution of the kernel function with a nonparametric estimator of the cumulative hazard function (Nelson-Aalen estimator).
}
\examples{
library(survival)
fit<-khazard(times = lung$time,delta = lung$status-1)
}
\references{
Selingerova, I., Dolezelova, H., Horova, I., Katina, S., and Zelinka, J. (2016). Survival of Patients with Primary Brain Tumors: Comparison of Two Statistical Approaches. PloS one, 11(2), e0148733.
}
\seealso{
\code{\link{plot.khazard}}, \code{\link[GA]{ga}}, \code{\link{optimize}}
}
