% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_embed.R
\name{process_embed}
\alias{process_embed}
\title{A tool designed to reduce redundant terms in a fitted embedding model}
\usage{
process_embed(
  x,
  words = NULL,
  punct = TRUE,
  tolower = TRUE,
  lemmatize = TRUE,
  stem = FALSE
)
}
\arguments{
\item{x}{A fitted word embedding model in the data frame format}

\item{words}{The name of a column that corresponds to the word dimension of the fitted word embeddings}

\item{punct}{Removes punctuation}

\item{tolower}{Combines terms that differ by case}

\item{lemmatize}{Combines terms that share a common lemma. Uses the lexicon package by default.}

\item{stem}{Combines terms that share a common stem. \emph{Note:} Stemming should not be used in conjunction with lemmatize.}
}
\value{
A data frame with the same columns as the input, but with redundant terms combined.
}
\description{
Takes a fitted embedding model as an input. Allows users to combine
embeddings by the case, stem, or lemma of associated terms.
}
\keyword{keyclust}
