% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{tol}
\alias{tol}
\title{Paul Tol's Color Schemes}
\description{
Paul Tol's Color Schemes
}
\details{
The maximum number of supported colors is only relevant for the qualitative
color schemes (divergent and sequential schemes are linearly interpolated).

\describe{
\item{Qualitative data}{\code{bright} (7), \verb{high contrast} (3), \code{vibrant} (7),
\code{muted} (9), \verb{medium contrast} (6), \code{pale} (6), \code{dark} (6), \code{light} (9).}
\item{Diverging data}{\code{sunset} (11), \code{nightfall} (17), \code{BuRd} (9),
\code{PRGn} (9).}
\item{Sequential data}{\code{YlOrBr} (9), \code{iridescent} (23), \code{incandescent}
(11), \verb{discrete rainbow} (23), \verb{smooth rainbow} (34).}
}
}
\section{Qualitative Color Schemes}{

The qualitative color schemes are used as given (no interpolation):
colors are picked up to the maximum number of supported values.

\tabular{ll}{
\strong{Palette}      \tab \strong{Max.} \cr
\code{bright}         \tab 7        \cr
\code{highcontrast}   \tab 3        \cr
\code{vibrant}        \tab 7        \cr
\code{muted}          \tab 9        \cr
\code{mediumcontrast} \tab 6        \cr
\code{pale}           \tab 6        \cr
\code{dark}           \tab 6        \cr
\code{light}          \tab 9        \cr
}

According to Paul Tol's technical note, the \code{bright}, \code{highcontrast},
\code{vibrant} and \code{muted} color schemes are color-blind safe. The
\code{mediumcontrast} color scheme is designed for situations needing color
pairs.

The \code{light} color scheme is reasonably distinct for both normal or
colorblind vision and is intended to fill labeled cells.

The \code{pale} and \code{dark} schemes are not very distinct in either normal or
colorblind vision and should be used as a text background or to highlight
a cell in a table.

Refer to the original document for details about the recommended uses (see
references)
}

\section{Diverging Color Schemes}{

If more colors than defined are needed from a given scheme, the color
coordinates are linearly interpolated to provide a continuous version of the
scheme.

\tabular{lll}{
\strong{Palette} \tab \strong{Max.} \tab \strong{NA value} \cr
\code{sunset}    \tab 11       \tab #FFFFFF      \cr
\code{nightfall} \tab 17       \tab #FFFFFF      \cr
\code{BuRd}      \tab 9        \tab #FFEE99      \cr
\code{PRGn}      \tab 9        \tab #FFEE99      \cr
}
}

\section{Sequential Color Schemes}{

If more colors than defined are needed from a given scheme, the color
coordinates are linearly interpolated to provide a continuous version of the
scheme.

\tabular{lll}{
\strong{Palette}       \tab \strong{Max.} \tab \strong{NA value} \cr
\code{YlOrBr}          \tab 9        \tab #888888      \cr
\code{iridescent}      \tab 23       \tab #999999      \cr
\code{discreterainbow} \tab 23       \tab #777777      \cr
\code{smoothrainbow}   \tab 34       \tab #666666      \cr
}
}

\section{Rainbow Color Scheme}{

As a general rule, ordered data should not be represented using a rainbow
scheme. There are three main arguments against such use (Tol 2018):
\itemize{
\item{The spectral order of visible light carries no inherent magnitude
message.}
\item{Some bands of almost constant hue with sharp transitions between
them, can be perceived as jumps in the data.}
\item{Color-blind people have difficulty distinguishing some colors of
the rainbow.}
}
If such use cannot be avoided, Paul Tol's technical note provides two color
schemes that are reasonably clear in color-blind vision. To remain
color-blind safe, these two schemes must comply with the following
conditions:
\describe{
\item{\code{discreterainbow}}{This scheme must not be interpolated.}
\item{\code{smoothrainbow}}{This scheme does not have to be used over the full
range.}
}
}

\references{
Tol, P. (2021). \emph{Colour Schemes}. SRON. Technical Note No.
SRON/EPS/TN/09-002, issue 3.2.
URL: \url{https://sronpersonalpages.nl/~pault/data/colourschemes.pdf}
}
\keyword{internal}
