% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identical_all.R
\name{identical_all}
\alias{identical_all}
\title{Check whether all inputs are identical}
\usage{
identical_all(...)
}
\arguments{
\item{...}{two or more R objects. If a vector or list is entered as
an input, the function will test whether the vector's or list's
elements are identical.}
}
\value{
the output will be \code{TRUE} if all inputs are identical
or \code{FALSE} if not
}
\description{
Check whether all inputs are identical
}
\examples{
identical_all(1:3, 1:3) # should return TRUE
identical_all(1:3, 1:3, 1:3, 1:3, 1:3) # should return TRUE
identical_all(1:3, 1:3, 1:3, 1:3, 1:3, 1:4) # should return FALSE
identical_all(1:10) # should return FALSE
identical_all(rep(1, 100)) # should return TRUE
identical_all(list(1, 1, 1)) # should return TRUE
identical_all(TRUE, FALSE) # should return FALSE
identical_all(FALSE, TRUE) # should return FALSE
}
