% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_regression_table.R
\name{logistic_regression_table}
\alias{logistic_regression_table}
\title{Logistic regression table}
\usage{
logistic_regression_table(
  logistic_reg_glm_object = NULL,
  z_values_keep = FALSE,
  constant_row_clean = TRUE,
  odds_ratio_cols_combine = TRUE,
  round_b_and_se = 3,
  round_z = 3,
  round_p = 3,
  round_odds_ratio = 3,
  round_r_sq = 3,
  round_model_chi_sq = 3,
  pretty_round_p_value = TRUE
)
}
\arguments{
\item{logistic_reg_glm_object}{a glm object estimating a
logistic regression model}

\item{z_values_keep}{logical. Should the z values be kept in the table?
(default = FALSE)}

\item{constant_row_clean}{logical. Should the row for the constant
be cleared except for b and standard error of b? (default = TRUE)}

\item{odds_ratio_cols_combine}{logical. Should the odds ratio columns
be combined? (default = TRUE)}

\item{round_b_and_se}{number of decimal places to which to round
b and standard error of b (default = 3)}

\item{round_z}{number of decimal places to which to round
z values (default = 3)}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{round_odds_ratio}{number of decimal places to which to round
odds ratios (default = 3)}

\item{round_r_sq}{number of decimal places to which to round
R-squared values (default = 3)}

\item{round_model_chi_sq}{number of decimal places to which to round
model chi-squared values (default = 3)}

\item{pretty_round_p_value}{logical. Should the p-values be rounded
in a pretty format (i.e., lower threshold: "<.001").
By default, \code{pretty_round_p_value = TRUE}.}
}
\value{
the output will be a summary of logistic regression results.
}
\description{
Construct a table of logistic regression results from the given
glm object estimating a logistic regression model.
}
\examples{
logistic_regression_table(logistic_reg_glm_object =
glm(formula = am ~ mpg, family = binomial(), data = mtcars))
logistic_regression_table(logistic_reg_glm_object =
glm(formula = am ~ mpg, family = binomial(), data = mtcars),
z_values_keep = TRUE, constant_row_clean = FALSE,
odds_ratio_cols_combine = FALSE)
}
