% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_mean_effect_size.R
\name{weighted_mean_effect_size}
\alias{weighted_mean_effect_size}
\title{Estimate the mean effect size in a meta analysis}
\usage{
weighted_mean_effect_size(
  effect_sizes = NULL,
  effect_size_variances = NULL,
  ci = 0.95,
  one_tailed = FALSE,
  random_vs_fixed = "random"
)
}
\arguments{
\item{effect_sizes}{effect sizes (e.g., standardized mean differences)}

\item{effect_size_variances}{within-study variances}

\item{ci}{width of the confidence interval (default = 0.95)}

\item{one_tailed}{logical. If \code{one_tailed = FALSE}, a two-tailed
p-value will be calculated. If \code{one_tailed = TRUE}, a one-tailed
p-value will be calculated (default = FALSE)}

\item{random_vs_fixed}{If \code{random_vs_fixed = "random"},
the summary effect will be calculated under the random-effects model
(default = "random").}
}
\description{
Estimate the mean effect size in a meta analysis, as illustrated
in Borenstein et al. (2009, pp. 73-74, ISBN: 978-0-470-05724-7)
}
\examples{
\dontrun{
weighted_mean_effect_size(
effect_sizes = c(1, 2), effect_size_variances = c(3, 4))
weighted_mean_effect_size(
effect_sizes = c(0.095, 0.277, 0.367, 0.664, 0.462, 0.185),
effect_size_variances = c(0.033, 0.031, 0.050, 0.011, 0.043, 0.023))
# if effect sizes have a variance of 0, they will be excluded from
# the analysis
weighted_mean_effect_size(
effect_sizes = c(1.1, 1.2, 1.3, 1.4),
effect_size_variances = c(1, 0, 0, 4))
}
}
