% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateKlass-graph-build.R
\name{klass_graph}
\alias{klass_graph}
\title{Build a directed graph of code changes based on a Klass classification}
\usage{
klass_graph(classification, date = NULL)
}
\arguments{
\item{classification}{The ID of the desired classification.}

\item{date}{The date which the edges of the graph should be directed towards.

  Defaults to the current year plus one, which ensures the graph is directed
  to the most recent codes.}
}
\value{
An \code{igraph} object with the vertexes representing codes, and
  edges representing changes between codes. The direction of the edges
  represent changes towards the date specified in \code{date}.
}
\description{
Build a directed graph of code changes based on a Klass classification
}
\examples{
library(klassR)

# Build a graph directed towards the most recent codes
\dontrun{
klass_131 <- klass_graph(131)
}

# Build a graph directed towards valid codes in 2020.
\dontrun{
klass_131_2020 <- klass_graph(131, "2020-01-01")
}

}
