% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_cor_plot.R
\name{factor_cor_plot}
\alias{factor_cor_plot}
\title{factor correlation plot}
\usage{
factor_cor_plot(
  data,
  FAC_1,
  FAC_2,
  num_fac = 3,
  text_col = "red",
  line_col = "lightblue"
)
}
\arguments{
\item{data}{A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis, see README for details. It will be that will be converted into
a plottable dataframe, see README for details or
a plottable data frame created from the \code{factor_analysis()} function}

\item{FAC_1}{the first factor to be compared. A string that can be chosen from FA1:FA3 or FA1:FAnum_fac e.g. "FA1"}

\item{FAC_2}{the first factor to be compared. A string that can be chosen from FA1:FA3 or FA1:FAnum_fac e.g. "FA2"}

\item{num_fac}{a numeric value for how many factors to analyze. Recommended to use 3 and default to 3.}

\item{text_col}{an R color, the color of the text lables, defaults to "red"}

\item{line_col}{an R color, the color of the lines, defaults to "lightblue"}
}
\value{
a ggplot object of the correlation plot
}
\description{
factor correlation plot
}
\examples{
data("Klovan_Row80")
fa_plot1 <- factor_cor_plot(Klovan_Row80, "FAC1", "FAC2", 2)
fa_plot1

factor_cor_plot(Klovan_Row80, "FAC1", "FAC3")

fa_plot2 <-factor_cor_plot(factor_analysis(Klovan_Row80), "FAC1", "FAC3", 4)
fa_plot2

}
