% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STUDY_ACROSS_SPECIES.R
\name{STUDY_ACROSS_SPECIES}
\alias{STUDY_ACROSS_SPECIES}
\title{Study k-mer composition across species.}
\usage{
STUDY_ACROSS_SPECIES(
  kmer.table,
  kmer.cutoff = 5,
  k,
  central.pattern = NULL,
  selected.extremophiles,
  other.extremophiles,
  output.dir = "study_across_species/",
  fasta.path
)
}
\arguments{
\item{kmer.table}{A data.table of kmer table or path to it.}

\item{kmer.cutoff}{Percentage of extreme kmers to study. Default to 5
percent.}

\item{k}{K-mer size.}

\item{central.pattern}{K-mer's central patterns. Default is NULL.}

\item{selected.extremophiles}{A vector of selected extremophile species. e.g.
c("Deinococcus soli", "Deinococcus deserti")
The best representative will be selected from the assembly summary.}

\item{other.extremophiles}{A vector of other extremophile species. These are
used as a control to compare with the selected extremophiles.}

\item{output.dir}{A directory for the outputs.}

\item{fasta.path}{Path to a directory of user-provided genome FASTA files or
the destination to save the NCBI/UCSC downloaded reference genome files.}
}
\value{
An output directory containing plots.
}
\description{
Analysis of distribution of highly enriched k-mers across species.
}
