% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnsemblVariantFeatures_serial.R
\name{getEnsemblVariantFeatures_serial}
\alias{getEnsemblVariantFeatures_serial}
\title{Get features of given variant IDs.}
\usage{
getEnsemblVariantFeatures_serial(
  species,
  variant.ids,
  include.genotypes = FALSE,
  include.phenotypes = FALSE,
  include.allele.frequencies = FALSE,
  include.genotype.frequencies = FALSE
)
}
\arguments{
\item{species}{Species name or alias (e.g., homo_sapiens, human).}

\item{variant.ids}{A vector of variant IDs (e.g., rs56116432, COSM476).}

\item{include.genotypes}{Include genotypes in the response? Default FALSE.}

\item{include.phenotypes}{Include phenotypes in the response? Default FALSE.}

\item{include.allele.frequencies}{Include allele frequencies? Default FALSE.}

\item{include.genotype.frequencies}{Include genotype frequencies? Default FALSE.}
}
\value{
A list, named by variant IDs, containing lists of variant features.
}
\description{
Function fetches variant features from the Ensembl database for a set
of variant IDs. It handles variant IDs in batches to comply with server limits
and can include additional information like genotypes, phenotypes, allele
frequencies, and genotype frequencies.
}
