% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixationFilterFunctions.R
\name{algorithm_idt}
\alias{algorithm_idt}
\title{Dispersion-based fixation detection algorithm \code{(I-DT)}}
\usage{
algorithm_idt(
  gaze_raw,
  one_degree = 40,
  dispersion.threshold = 1,
  min.duration = 50,
  xcol = "x.raw",
  ycol = "y.raw",
  distance.threshold = 0.7,
  merge.ms.threshold = 75,
  missing.samples.threshold = 0.5
)
}
\arguments{
\item{gaze_raw}{Data frame with gaze data before fixation detection. Include the variable timestamp with timing in ms and columns with raw
x and y data as specified by the parameters xcol and ycol or their default values}

\item{one_degree}{One degree of the visual field in the unit of the raw x and y coordinates. The unit is typically pixels or proportion
of the screen. Make sure that the setting matches your data}

\item{dispersion.threshold}{Maximum radius of fixation candidates. Samples clustering within a circle of this limit will be
classified as a fixation if the duration is long enough.}

\item{min.duration}{Minimum duration of fixations in milliseconds}

\item{xcol}{Name of the column where raw x values are stored. Default: x.raw}

\item{ycol}{Name of the column where raw y values are stored. Default: y.raw}

\item{distance.threshold}{Subsequent fixations occurring withing this distance are merged. Set to 0 if you don't want to merge fixations.}

\item{merge.ms.threshold}{Only subsequent fixations occurring within this time window are merged}

\item{missing.samples.threshold}{Remove fixations with a higher proportion of missing samples. Range 0-1}
}
\value{
list including separate data frames for fixations and sample-by-sample data including gaze coordinates before and after fixation detection.
The fixations data frame includes onset, offset, x, y, sample-to-sample root-mean-square deviations (RMSD, precision), RMSD from fixation centroid,  and missing samples of each fixation.
}
\description{
Apply a dispersion-based fixation \code{(I-DT)} filter to the eye tracking data.
The algorithm identifies fixations as samples clustering within a spatial area.
The procedure is described in Blignaut 2009
Input data must be a data frame with the variables timestamp, x.raw and y.raw as variables. Other variables can
be included but will be ignored. This function does not perform pre-processing in the form of interpolation or smoothing. Use the function preprocess_gaze for this.
Timestamps are assumed to be in milliseconds.
The output data is a list with two data frames: fixations includes all detected fixations with coordinates, duration
and a number of other metrics, filt.gaze is a sample-by-sample data frame with time stamps, raw gaze coordinates (e.g., before event detection) and
fixation coordinates.
The function can be very slow for long recordings and/or data recorded at high sampling rates.
}
