% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu.R
\name{kuzu_get_n}
\alias{kuzu_get_n}
\title{Retrieve the First N Rows from a Query Result}
\usage{
kuzu_get_n(result, n)
}
\arguments{
\item{result}{A Kuzu query result object.}

\item{n}{The number of rows to retrieve.}
}
\value{
A list of the first \code{n} rows.
}
\description{
Fetches the first \code{n} rows from a Kuzu query result.
}
\examples{
\donttest{
conn <- kuzu_connection(":memory:")
kuzu_execute(conn, "CREATE NODE TABLE User(name STRING, age INT64, 
PRIMARY KEY (name))")
kuzu_execute(conn, "CREATE (:User {name: 'Alice', age: 25})")
kuzu_execute(conn, "CREATE (:User {name: 'Bob', age: 30})")
result <- kuzu_execute(conn, "MATCH (a:User) RETURN a.name, a.age")
first_row <- kuzu_get_n(result, 1)
}
}
