% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambdr.R
\docType{package}
\name{lambdr-package}
\alias{lambdr}
\alias{lambdr-package}
\title{lambdr: Create a Runtime for Serving Containerised R Functions on AWS Lambda}
\description{
\if{html}{\figure{lambdr.png}{options: alt='logo' width='150'}}

This package provides an R runtime for the
\href{https://aws.amazon.com/lambda/}{\emph{AWS Lambda} serverless compute
service}. It is intended to be used to create containers that can run on \emph{AWS
Lambda}. \code{lambdr} provides the necessary functionality for handling the
various endpoints required for accepting new input and sending responses.

This package is \strong{unofficial}. Its creators are not affiliated with \emph{Amazon
Web Services}, nor is its content endorsed by \emph{Amazon Web Services}.
\emph{Lambda}, \emph{API Gateway}, \emph{EventBridge}, \emph{CloudWatch}, and \emph{SNS} are services
of \emph{Amazon Web Services}.

To see an example of how to use this package to create a runtime, refer to
\code{vignette("lambda-runtime-in-container", package = "lambdr")}.

The default behaviour is to convert the body of the received event from JSON
into arguments for the handler function using the \code{jsonlite} package. For
example, a raw event body of \code{{"number": 9}} will be converted to
\code{list(number = 9)}. The handler function will then receive the arguments
directly after unlisting, eg. \code{number = 9}. This works for direct
invocations, as well as situations where the user wishes to implement
behaviour specific to a trigger.

Some invocation types have their own logic for converting the event body into
an R object. This is useful for say, using an R function in a Lambda behind
an API Gateway, so that the R function does not need to deal with the HTML
elements of the invocation. The below invocation types have custom logic
implemented. Refer to the vignettes or the package website for more
information.

Alternatively, user-defined functions can be provided for parsing event
content and serialising results. The user can also use the \code{identity}
function as a deserialiser to pass the raw event content --- as a string ---
to the handler function. Refer to \code{\link{lambda_config}} for more
information.
}
\section{Direct invocations}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}

\section{REST API Gateway invocations}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{vignette("api-gateway-invocations", package = "lambdr")}
}

\section{HTML API Gateway invocations}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{vignette("api-gateway-invocations", package = "lambdr")}
}

\section{EventBridge invocations}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{vignette("eventbridge-and-sns-invocations", package = "lambdr")}
}

\section{SNS invocations}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{vignette("eventbridge-and-sns-invocations", package = "lambdr")}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://lambdr.mdneuzerling.com/}
  \item \url{https://github.com/mdneuzerling/lambdr}
  \item Report bugs at \url{https://github.com/mdneuzerling/lambdr/issues}
}

}
\author{
\strong{Maintainer}: David Neuzerling \email{david@neuzerling.com}

Other contributors:
\itemize{
  \item James Goldie \email{me@jamesgoldie.dev} [contributor]
}

}
