% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_unique_values.R
\name{get_unique_values}
\alias{get_unique_values}
\title{get_unique_values}
\usage{
get_unique_values(x, simplify = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{Vector, matrix, raster, stars, or terra object or list of previous.}

\item{simplify}{If true, a vector will be returned instead of a list for
1-dimensional input}

\item{verbose}{If true, warning messages are printed}
}
\description{
This function returns the unique values of an object.
}
\details{
Fast and memory friendly Rcpp implementation to find the unique values of an object.
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)

get_unique_values(landscape)

landscape_stack <- c(landscape, landscape, landscape)
get_unique_values(landscape_stack)

landscape_matrix <- terra::as.matrix(landscape, wide = TRUE)
get_unique_values(landscape_matrix)

x_vec <- c(1, 2, 1, 1, 2, 2)
get_unique_values(x_vec)

landscape_list <- list(landscape, landscape_matrix, x_vec)
get_unique_values(landscape_list)

}
