% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_allocation}
\alias{plot_allocation}
\title{Plotting allocation of croptypes in a landscape}
\usage{
plot_allocation(
  landscape,
  year,
  croptype_names = c(),
  title = "",
  subtitle = "",
  filename = "landscape.png"
)
}
\arguments{
\item{landscape}{a SpatialPolygonsDataFrame}

\item{year}{year to be plotted}

\item{croptype_names}{croptype names (for legend)}

\item{title}{title of the graphic}

\item{subtitle}{subtitle of the graphic}

\item{filename}{name of the .png file to be generated}
}
\value{
a png file.
}
\description{
Plots croptype allocation in the landscape at a given year of the simulation
}
\examples{
\dontrun{
landscape <- landscapeTEST1
croptypes <- data.frame(sample.int(3, length(landscape), replace = TRUE))
allocation <- SpatialPolygonsDataFrame(landscape, croptypes, match.ID = TRUE)
plot_allocation(allocation, 1,
  title = "Simulated landscape", subtitle = "Year 1",
  filename = paste(getwd(), "/landscape.png", sep = "")
)
}
}
\seealso{
\link{plotland}
}
