% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plots.R
\name{mplot_lineal}
\alias{mplot_lineal}
\title{Linear Regression Results Plot}
\usage{
mplot_lineal(
  tag,
  score,
  subtitle = NA,
  model_name = NA,
  save = FALSE,
  subdir = NA,
  file_name = "viz_lineal.png"
)
}
\arguments{
\item{tag}{Vector. Real known label.}

\item{score}{Vector. Predicted value or model's result.}

\item{subtitle}{Character. Subtitle to show in plot}

\item{model_name}{Character. Model's name}

\item{save}{Boolean. Save output plot into working directory}

\item{subdir}{Character. Sub directory on which you wish to save the plot}

\item{file_name}{Character. File name as you wish to save the plot}
}
\value{
Plot with linear distribution and performance results.
}
\description{
This function plots a Linear Regression Result
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dfr) # Results for AutoML Predictions
lapply(dfr, head)
mplot_lineal(dfr$regr$tag, dfr$regr$score, model_name = "Titanic Fare Model")
}
\seealso{
Other ML Visualization: 
\code{\link{mplot_conf}()},
\code{\link{mplot_cuts}()},
\code{\link{mplot_cuts_error}()},
\code{\link{mplot_density}()},
\code{\link{mplot_full}()},
\code{\link{mplot_gain}()},
\code{\link{mplot_importance}()},
\code{\link{mplot_metrics}()},
\code{\link{mplot_response}()},
\code{\link{mplot_roc}()},
\code{\link{mplot_splits}()},
\code{\link{mplot_topcats}()}
}
\concept{ML Visualization}
