% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/model.R
\name{predictPostprob}
\alias{predictPostprob}
\alias{predictPostprob,lcModel-method}
\title{Posterior probability for new data}
\usage{
predictPostprob(object, newdata = NULL, ...)

\S4method{predictPostprob}{lcModel}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{The model.}

\item{newdata}{Optional \code{data.frame} for which to compute the posterior probability. If omitted, the model training data is used.}

\item{...}{Additional arguments passed to \link{postprob}.}
}
\value{
A N-by-K \code{matrix} indicating the posterior probability per trajectory per measurement on each row, for each cluster (the columns).
Here, \code{N = nrow(newdata)} and \code{K = nClusters(object)}.
}
\description{
Returns the observation-specific posterior probabilities for the given data.

For \code{lcModel}: The default implementation returns a uniform probability matrix.
}
\section{Implementation}{

Classes extending \code{lcModel} should override this method to enable posterior probability predictions for new data.
\preformatted{
setMethod("predictPostprob", "lcModelExt", function(object, newdata = NULL, ...) {
  # return observation-specific posterior probability matrix
})
}
}

\seealso{
\link{postprob}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
