% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazysf.R
\docType{data}
\name{st_as_sf}
\alias{st_as_sf}
\alias{st_as_sf.tbl_SFSQLConnection}
\alias{collect}
\title{Force computation of a GDAL query}
\format{
An object of class \code{function} of length 1.
}
\usage{
\method{st_as_sf}{tbl_SFSQLConnection}(x, ...)

collect(x, ...)
}
\arguments{
\item{x}{output of \code{\link[=lazysf]{lazysf()}}}

\item{...}{passed to \code{\link[=collect]{collect()}}}
}
\value{
a data frame from \code{collect()}, sf data frame from \code{st_as_sf()} (only if it contains an \code{sfc} geometry column)
}
\description{
Convert lazysf to an in memory data frame or sf object
}
\details{
\code{collect()} retrieves data into a local table, preserving grouping and ordering.

\code{st_as_sf()} retrieves data into a local sf data frame (will succeed only if there is a geometry column of class \code{sfc})
}
\examples{
f <- system.file("gpkg/nc.gpkg", package = "sf", mustWork = TRUE)
lsf <- lazysf(f) \%>\% dplyr::select(AREA, FIPS, geom) \%>\% dplyr::filter(AREA < 0.1)
st_as_sf(lsf)


}
\seealso{
lazysf
}
\keyword{datasets}
