% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{print.summary.lcc}
\alias{print.summary.lcc}
\title{Print Summary of an \code{lcc} Object}
\usage{
\method{print}{summary.lcc}(x, verbose = FALSE, digits = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{\link[lcc]{summary.lcc}},
representing a summarized longitudinal concordance correlation function.}

\item{verbose}{Logical value to control the amount of printed output for
model details. Defaults to \code{FALSE}.}

\item{digits}{Specifies the minimum number of significant digits to be
printed in values. Default is \code{NULL}.}

\item{...}{Further arguments passed to \code{print}.}
}
\description{
Provides a detailed summary of a fitted longitudinal
  concordance correlation model, including AIC, BIC, log-likelihood, and
  other relevant statistics. The function supports detailed output for
  different types of model fits.
}
\examples{
\dontrun{
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
           method = "Method", time = "Time", qf = 2, qr = 2)
print(summary(fm1, type = "model"))
}

}
\seealso{
\code{\link{summary.lcc}}, \code{\link{lccPlot}},
  \code{\link[lcc]{lcc}}
}
