% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_bottom.R
\name{w_bottom}
\alias{w_bottom}
\title{w bottom technical analysis function}
\usage{
w_bottom(h,top,down,month,day)
}
\arguments{
\item{h}{an stock data}

\item{top}{an rsi rise horizon value}

\item{down}{an rsi down horizon value}

\item{month}{set the length between the start and end points. Unit:month}

\item{day}{check the correctness of the end point, set the length between the end and check points. Unit:day}
}
\value{
an analysis of stock data for w bottom technical analysis indicators
}
\description{
w bottom technical analysis function is to analyze the reversal pattern conform to the rising trend of stock data
}
\details{
use RSI analysis of the strength of the stock market trend, analyze trends conform to w bottom, and RSI function need library 'TTR'
}
\note{
the month value must be more than one month
}
\examples{
\dontrun{
library(quantmod)
aapl<-getSymbols("AAPL",src="yahoo",auto.assign=FALSE)
w_bottom(aapl,60,40,2,20)
}
}
\author{
Chun-Yu Liu <john401528@gmail.com>
}
