% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{lai.raster}
\alias{lai.raster}
\title{Produce a raster map of LAI. The resolution of the raster depends of grain.size choosed on lad.voxel() funtion.}
\usage{
lai.raster(VOXELS_LAD, min = 1, relative.value = NULL)
}
\arguments{
\item{VOXELS_LAD}{3D grid of LAD values (output of lad.voxels() function)}

\item{min}{mix canopy height}

\item{relative.value}{LAI map can be made in percentage of a relative lai value (indicate for effective LAI)

A Leaf Area Index (LAI) \code{\link[raster:Raster-classes]{RasterLayer}} produced from the LAD voxels output from \code{\link[=lad.voxels]{lad.voxels()}} function.}
}
\description{
Produce a raster map of LAI. The resolution of the raster depends of grain.size choosed on lad.voxel() funtion.
}
\examples{
library(raster)
# Get the example laz file
normlas.file = system.file("extdata", "lidar_example.laz", package="leafR")

# Calculate LAD from voxelization
# use thicker grain size to avoid voxels
# without returns
VOXELS_LAD.5 = lad.voxels(normlas.file,
                        grain.size = 5, k=1)

#Map using absolute values
lai_raster = lai.raster(VOXELS_LAD.5)
plot(lai_raster)

#############################
## RELATIVE LAI Raster
######################
# Calculate voxels LAD with finer grain size for
# better estimation of LAI
VOXELS_LAD = lad.voxels(normlas.file,
                        grain.size = 2)

# Calculate the LAD profile
lad_profile = lad.profile(VOXELS_LAD)

#Calculate LAI derived from LAD profile
lidar.lai = lai(lad_profile)

#Map using relative values (\%)
relative.lai_raster = lai.raster(VOXELS_LAD.5, relative.value = lidar.lai)
plot(relative.lai_raster)

}
