% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{validate_and_preprocess_data}
\alias{validate_and_preprocess_data}
\title{Robust data validation and preprocessing}
\usage{
validate_and_preprocess_data(data, target, split, id)
}
\arguments{
\item{data}{A data frame, tibble, or data table to be validated and preprocessed.}

\item{target}{The name of the target column, which should be present in the \code{data}. If \code{NULL}, no target validation is performed.}

\item{split}{A vector specifying the split column, which will be checked in the \code{data}. If \code{NULL}, no split validation is performed.}

\item{id}{The name of the ID column, which should be present in the \code{data}. If \code{NULL}, no ID validation is performed.}
}
\value{
The validated and preprocessed data.
}
\description{
This function performs data validation and preprocessing for audit purposes. It checks the validity of the input data,
ensures that the target and ID columns exist, and handles empty or problematic columns.
}
\examples{
\dontrun{
# Example data
data <- data.frame(target = rnorm(100), id = 1:100)
target <- "target"
id <- "id"
validated_data <- validate_and_preprocess_data(data, target, NULL, id)
}

}
\keyword{internal}
