% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{school}
\alias{school}
\title{Subset of the School data available for the years 2000-2022 from the PISA OECD database}
\format{
A tibble of the following variables
\itemize{
    \item \code{year}: Year of the PISA data. Integer.
    \item \code{country}: Country 3 character code. Note that some regions/territories are coded as country for ease of input. Chracter.
    \item \code{school_id}: The school identification number, unique for each country and year combination. Character.
    \item \code{fund_gov}: Percentage of total funding for school year from government. Numeric.
    \item \code{fund_fees}: Percentage of total funding for school year from student fees or school charges paid by parents. Numeric.
    \item \code{fund_donation}: Percentage of total funding for school year from
    benefactors, donations, bequests, sponsorship, parent fundraising. Numeric.
    \item \code{enrol_boys}: Number of boys in the school. Numeric.
    \item \code{enrol_girls}: Number of girls in the school. Numeric.
    \item \code{stratio}: Student-Teacher ratio. Numeric.
    \item \code{public_private}: Is the school a public or private school. Factor.
    \item \code{staff_shortage}: Shortage of staff. Numeric.
    \item \code{sch_wgt}: The final survey weight score for the schools. Numeric.
    \item \code{school_size}: The school size. Numeric.
    }
}
\description{
A subset data containing school weight and other information
from the triennial testing of 15 year olds around
the globe. Original data available from
 \url{https://www.oecd.org/en/about/programmes/pisa/pisa-data.html}.
}
