% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-dendro.R
\name{scale_x_dendro}
\alias{scale_x_dendro}
\alias{scale_y_dendro}
\title{Dendrogram scales}
\usage{
scale_x_dendro(
  clust,
  ...,
  expand = waiver(),
  guide = "axis_dendro",
  position = "bottom"
)

scale_y_dendro(
  clust,
  ...,
  expand = waiver(),
  guide = "axis_dendro",
  position = "left"
)
}
\arguments{
\item{clust}{A data structure that can be coerced to an
\code{\link[stats:hclust]{<hclust>}} object through
\code{\link[stats:as.hclust]{as.hclust()}}.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{aesthetics}}{The names of the aesthetics that this scale works with.}
    \item{\code{palette}}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take (e.g., \code{\link[scales:pal_hue]{scales::pal_hue()}}).}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
}
\value{
A \verb{<ScaleDiscretePosition>} object that can be added to a plot.
}
\description{
These are speciality scales for use with hierarchically clustered data. The
scale automatically orders the limits according to the clustering result
and comes with a \link[=guide_axis_dendro]{dendrogram axis}.
}
\details{
The scale limits are determined by the order and labels in the \code{clust}
argument. While \code{limits} is not an argument in these scales, the \code{breaks}
argument can still be used to selectively omit some breaks and the \code{labels}
can be used for formatting purposes.
}
\examples{
# Hierarchically cluster data, separately for rows and columns
car_clust <- hclust(dist(scale(mtcars)), "ave")
var_clust <- hclust(dist(scale(t(mtcars))), "ave")

long_mtcars <- data.frame(
  car = rownames(mtcars)[row(mtcars)],
  var = colnames(mtcars)[col(mtcars)],
  value = as.vector(scale(mtcars))
)

# A standard heatmap adorned with dendrograms
p <- ggplot(long_mtcars, aes(var, car, fill = value)) +
  geom_tile() +
  scale_x_dendro(var_clust) +
  scale_y_dendro(car_clust)
p

# Styling the dendrograms
p +
  guides(
    y = guide_axis_dendro(key_dendro(type = "triangle")),
    x = guide_axis_dendro(space = rel(5))
  ) +
  theme(
    axis.text.y.left = element_text(margin = margin(r = 3, l = 3)),
    axis.ticks.y = element_line("red"),
    axis.ticks.x = element_line(linetype = "dotted")
  )

# In polar coordinates, plus some formatting
p +
  coord_radial(
    theta = "y", inner.radius = 0.5,
    start = 0.25 * pi, end = 1.75 * pi
  ) +
  guides(
    theta = primitive_labels(angle = 90),
    theta.sec = primitive_segments("dendro", vanish = TRUE),
    r = guide_axis_dendro(angle = 0)
  )
}
\seealso{
\code{\link[=guide_axis_dendro]{guide_axis_dendro()}}
}
