% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-axis-nested.R
\name{guide_axis_nested}
\alias{guide_axis_nested}
\title{Nested axis guide}
\usage{
guide_axis_nested(
  key = "range_auto",
  regular_key = "auto",
  type = "bracket",
  title = waiver(),
  theme = NULL,
  angle = waiver(),
  cap = "none",
  bidi = FALSE,
  oob = "squish",
  drop_zero = TRUE,
  pad_discrete = NULL,
  levels_text = NULL,
  ...,
  order = 0,
  position = waiver()
)
}
\arguments{
\item{key}{One of the following:
\itemize{
\item A \link[=key_range]{range key} specification. If not \code{key = "range_auto"},
additional labels will be inserted to represent point values.
\item A \verb{<character[1]>} passed to the \code{\link[=key_range_auto]{key_range_auto(sep)}}
argument. An exception is made when the string is a valid key
specification.
}}

\item{regular_key}{A \link[=key_standard]{standard key} specification for the
appearance of regular tick marks.}

\item{type}{Appearance of ranges, either \code{"box"} to put text in boxes or
\code{"bracket"} (default) to text brackets.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{angle}{A specification for the text angle. Compared to setting the \code{angle} argument
in \code{\link[ggplot2:element]{element_text()}}, this argument uses some
heuristics to automatically pick the \code{hjust} and \code{vjust} that you
probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take angles and justification settings directly from the theme.
\item \code{\link[ggplot2:waiver]{waiver()}} to allow reasonable defaults in special
cases.
\item A \verb{<numeric[1]>} between -360 and 360 for the text angle in degrees.
}}

\item{cap}{A method to cap the axes. One of the following:
\itemize{
\item A \verb{<character[1]>} with one of the following:
\itemize{
\item \code{"none"} to perform no capping.
\item \code{"both"} to cap the line at both ends at the most extreme breaks.
\item \code{"upper"} to cap the line at the upper extreme break.
\item \code{"lower"} to cap the line at the lower extreme break.
}
\item A \verb{<logical>[1]}, where \code{TRUE} is equivalent to \code{"both"} and \code{FALSE}
is equivalent to \code{"none"} in the options above.
\item A sorted \verb{<numeric>[2n]} with an even number of members. The lines
will be drawn between every odd-even pair.
\item A \verb{<function>} that takes the scale's breaks as the first argument, the
scale's limits as the second argument and returns a \verb{<numeric>[2n]} as
described above.
}}

\item{bidi}{A \verb{<logical[1]>}: whether ticks should be drawn bidirectionally
(\code{TRUE}) or in a single direction (\code{FALSE}, default).}

\item{oob}{A method for dealing with out-of-bounds (oob) ranges. Can be one
of \code{"squish"}, \code{"censor"} or \code{"none"}.}

\item{drop_zero}{A \verb{<logical[1]>} whether to drop near-zero width ranges
(\code{TRUE}, default) or preserve them (\code{FALSE}).}

\item{pad_discrete}{A \verb{<numeric[1]>} giving the amount ranges should be
extended when given as a discrete variable. This is applied after
the \code{drop_zero} setting.}

\item{levels_text}{A list of \verb{<element_text>} objects to customise how
text appears at every level.}

\item{...}{Arguments passed on to \code{\link[=primitive_bracket]{primitive_bracket()}},
\code{\link[=primitive_box]{primitive_box()}} or \code{\link[=primitive_fence]{primitive_fence()}}.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \verb{<Guide>} object.
}
\description{
This axis guide gives extra range annotations to position scales. It can
be used to infer nesting structure from labels or annotate ranges.
}
\details{
Under the hood, this guide is a \link[=compose_stack]{stack composition} of a
\link[=primitive_line]{line}, \link[=primitive_ticks]{ticks}, optionally
\link[=primitive_labels]{labels} and either \link[=primitive_bracket]{bracket},
\link[=primitive_box]{box} or \link[=primitive_fence]{fence} primitives.

By default, the \code{\link[=key_range]{key = "range_auto"}} will incorporate the 0th
level labels inferred from the scale's labels. These labels will look like
regular labels.

To offer other keys the opportunity to display ranges alongside
regular-looking labels, the \code{regular_key} argument can be used to setup a
separate key for display in between the ticks and ranges.
}
\examples{
# A plot with nested categories on the x-axis
p <- ggplot(mpg, aes(interaction(drv, cyl), hwy)) +
  geom_boxplot()

p + guides(x = "axis_nested")

# Apply styling to brackets
p + guides(x = "axis_nested") +
  theme_guide(bracket = element_line("red", linewidth = 1))

# Don't drop nesting indicators that have 0-width
p + guides(x = guide_axis_nested(drop_zero = FALSE))

# Change additional padding for discrete categories
p + guides(x = guide_axis_nested(pad_discrete = 0))

# Change bracket type
p + guides(x = guide_axis_nested(bracket = "curvy"))

# Use boxes instead of brackets + styling of boxes
p + guides(x = guide_axis_nested(type = "box")) +
  theme_guide(box = element_rect("limegreen", "forestgreen"))

# Using fences instead of brackets + styling of fences
p + guides(x = guide_axis_nested(type = "fence", rail = "inner")) +
  theme_guide(
    fence.post = element_line("tomato"),
    fence.rail = element_line("dodgerblue")
  )

# Use as annotation of a typical axis
# `regular_key` controls display of typical axis
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  guides(x = guide_axis_nested(
    key = key_range_manual(start = 2:3, end = 5:6, name = c("First", "Second")),
    regular_key = key_manual(c(2, 2.5, 3, 5, 7))
  ))
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_dendro}()},
\code{\link{guide_circles}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colring}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}
}
\concept{standalone guides}
