# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Efficient Matrix Multiplication
#'
#' Performs matrix multiplication using RcppArmadillo
#'
#' @param A First input matrix
#' @param B Second input matrix
#' @return Matrix product of A and B
#' @export
#' @keywords internal
efficient_matrix_mult <- function(A, B) {
    .Call('_lgspline_efficient_matrix_mult', PACKAGE = 'lgspline', A, B)
}

#' Compute Gram Matrix
#'
#' Calculates X^T * X for the input matrix X
#'
#' @param X Input matrix
#' @return Gram matrix (X^T * X)
#' @export
#' @keywords internal
gramMatrix <- function(X) {
    .Call('_lgspline_gramMatrix', PACKAGE = 'lgspline', X)
}

#' Matrix Inversion using Armadillo
#'
#' Computes the inverse of a matrix using Armadillo's inversion method
#'
#' @param x Input matrix to be inverted
#' @return Inverted matrix
#' @export
#' @keywords internal
armaInv <- function(x) {
    .Call('_lgspline_armaInv', PACKAGE = 'lgspline', x)
}

#' Block Matrix Multiplication
#'
#' Performs multiplication of a list of matrices with a block matrix
#'
#' @param G List of matrices G
#' @param A Input matrix A
#' @param K Number of blocks
#' @param nc Number of columns
#' @param nca Number of columns in A
#' @return List of multiplied matrices
#' @noRd
#' @keywords internal
GAmult <- function(G, A, K, nc, nca) {
    .Call('_lgspline_GAmult', PACKAGE = 'lgspline', G, A, K, nc, nca)
}

#' Compute Trace Correction
#'
#' Calculates a trace correction for matrix computations
#'
#' @param G List of matrices G
#' @param A Input matrix A
#' @param GXX List of GX^{T}X matrices
#' @param AGAInv Matrix (A^{T}GA)^{-1}
#' @param nc Number of columns of each partition of G
#' @param K Number of blocks
#' @return Trace correction value
#' @noRd
#' @keywords internal
compute_trace_correction <- function(G, A, GXX, AGAInv, nc, K) {
    .Call('_lgspline_compute_trace_correction', PACKAGE = 'lgspline', G, A, GXX, AGAInv, nc, K)
}

#' AGAmult Computation Overall
#'
#' Performs A^{T}GA computation over all matrices in a list (G)
#'
#' @param G_chunk List of matrices for the chunk
#' @param A Input matrix A
#' @param K Number of partitions minus one
#' @param nc Number of columns
#' @return Resulting matrix
#' @noRd
#' @keywords internal
AGAmult <- function(G, A, K, nc, nca) {
    .Call('_lgspline_AGAmult', PACKAGE = 'lgspline', G, A, K, nc, nca)
}

#' Chunk-based AGAmult Computation
#'
#' Performs A^{T}GAmult computation on a specific chunk of matrices
#'
#' @param G_chunk List of matrices for the chunk
#' @param A Input matrix A
#' @param chunk_start Starting chunk index
#' @param chunk_end Ending chunk index
#' @param nc Number of columns
#' @return Resulting matrix
#' @noRd
#' @keywords internal
AGAmult_chunk <- function(G_chunk, A, chunk_start, chunk_end, nc) {
    .Call('_lgspline_AGAmult_chunk', PACKAGE = 'lgspline', G_chunk, A, chunk_start, chunk_end, nc)
}

#' Compute AGXy
#'
#' Computes A^T * G * Xy for specified range
#'
#' @param G List of G matrices
#' @param A Input matrix A
#' @param Xy List of Xy vectors
#' @param nc Number of columns
#' @param K Total number of blocks
#' @param start Start index
#' @param end End index
#' @return Resulting vector
#' @noRd
#' @keywords internal
compute_AGXy <- function(G, A, Xy, nc, K, start, end) {
    .Call('_lgspline_compute_AGXy', PACKAGE = 'lgspline', G, A, Xy, nc, K, start, end)
}

#' Compute Result Blocks
#'
#' Computes blocks of results for specific computations
#'
#' @param G List of G matrices
#' @param Ghalf List of Ghalf matrices
#' @param A Input matrix A
#' @param AAGAInvAGXy Input vector
#' @param nc Number of columns
#' @param start Start index
#' @param end End index
#' @return Resulting vector of blocks
#' @noRd
#' @keywords internal
compute_result_blocks <- function(G, Ghalf, A, AAGAInvAGXy, nc, start, end) {
    .Call('_lgspline_compute_result_blocks', PACKAGE = 'lgspline', G, Ghalf, A, AAGAInvAGXy, nc, start, end)
}

#' Block Diagonal Matrix Multiplication
#'
#' Performs multiplication of block diagonal matrices
#'
#' @param A List of matrices A
#' @param B List of matrices B
#' @param K Number of blocks
#' @return List of multiplied matrices
#' @noRd
#' @keywords internal
matmult_block_diagonal_cpp <- function(A, B, K) {
    .Call('_lgspline_matmult_block_diagonal_cpp', PACKAGE = 'lgspline', A, B, K)
}

#' Vector-Matrix Multiplication for Block Diagonal Matrices
#'
#' Performs vector-matrix multiplication for block diagonal matrices
#'
#' @param A List of matrices A
#' @param b List of vectors b
#' @param K Number of blocks
#' @return List of resulting vectors
#' @export
#' @keywords internal
vectorproduct_block_diagonal <- function(A, b, K) {
    .Call('_lgspline_vectorproduct_block_diagonal', PACKAGE = 'lgspline', A, b, K)
}

#' Matrix-Matrix Addition for Block Diagonal Matrices
#'
#' Performs matrix-matrix elementwise addition for block diagonal matrices
#'
#' @param A List of matrices A
#' @param B List of matrices B
#' @param K Number of blocks
#' @return List of resulting matrices
#' @noRd
#' @keywords internal
matadd_block_diagonal <- function(A, B, K) {
    .Call('_lgspline_matadd_block_diagonal', PACKAGE = 'lgspline', A, B, K)
}

#' Compute Derivative of W
#'
#' Computes derivative of diag(1/(1-XUGXt)) with respect to lambda, penalties of G
#'
#' @param A List of matrices A
#' @param GXX List of matrices of G times gram matrix of X transpose for each partition
#' @param Ghalf List of matrices of square-root of G for each partition
#' @param dG_dlambda List of derivatives of G matrix with respect to penalties lambda
#' @param dGhalf_dlambda List of derivatives of Ghalf matrix with respect to penalties lambda
#' @param AGAInv Matrix of A transpose times G times A within U = (I - GA(A^{T}GA)^{-1}A^{T})
#' @param nc Numeric numeric of basis expansions of predictors per partition
#' @param K Number of blocks
#' @return Matrix representing the derivative
#' @noRd
#' @keywords internal
compute_dW_dlambda <- function(G, A, GXX, Ghalf, dG_dlambda, dGhalf_dlambda, AGAInv, nc, K) {
    .Call('_lgspline_compute_dW_dlambda', PACKAGE = 'lgspline', G, A, GXX, Ghalf, dG_dlambda, dGhalf_dlambda, AGAInv, nc, K)
}

#' Compute G^{1/2}(GA(A^{T}GA)^{-1}A^{T})GX^{T}y 
#'
#' Computes the equivalent vector of G^{1/2}X^{T}y in the proposed model-fitting procedure but for G^{1/2}(GA(A^{T}GA)^{-1}A^{T})GX^{T}y instead.
#'
#' @param G List of matrices of G times gram matrix of X transpose for each partition
#' @param Ghalf List of matrices of square-root of G for each partition
#' @param A List of matrices A
#' @param AGAInv Matrix of A transpose times G times A within U = (I - GA(A^{T}GA)^{-1}A^{T})
#' @param Xy List of vectors for partition-wise dot product of transpose(X) times vector y
#' @param nc Numeric numeric of basis expansions of predictors per partition
#' @param K Number of blocks
#' @return Matrix representing the operation
#' @noRd
#' @keywords internal
compute_GhalfXy_temp <- function(G, Ghalf, A, AGAInv, Xy, nc, K) {
    .Call('_lgspline_compute_GhalfXy_temp', PACKAGE = 'lgspline', G, Ghalf, A, AGAInv, Xy, nc, K)
}

#' Left-Multiply a List of Block-Diagonal Matrices by U 
#'
#' Useful for computing UG where G is a list of block-diagonal matrices for each partition, and U is a square P by P dense matrix
#'
#' @param U Matrix of dimension P by P that projects onto the null space of A transpose
#' @param G List of G matrices for each partition
#' @param nc Numeric numeric of basis expansions of predictors per partition
#' @param K Number of blocks
#' @return Matrix of UG
#' @export
#' @keywords internal
matmult_U <- function(U, G, nc, K) {
    .Call('_lgspline_matmult_U', PACKAGE = 'lgspline', U, G, nc, K)
}

