% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_exr.R
\name{write_exr}
\alias{write_exr}
\title{Write an OpenEXR image}
\usage{
write_exr(path, r, g, b, a = matrix(1, nrow = nrow(r), ncol = ncol(r)))
}
\arguments{
\item{path}{Character scalar output file.}

\item{r}{Numeric matrix, red channel.}

\item{g}{Numeric matrix, green channel.}

\item{b}{Numeric matrix, blue channel.}

\item{a}{Numeric matrix, alpha channel.}
}
\value{
None.
}
\description{
Save RGBA numeric matrices to an OpenEXR file (32‑bit float, ZIP compression).
}
\examples{
#Write the included data to an EXR file
tmpfile = tempfile(fileext = ".exr")
write_exr(tmpfile,
          widecolorgamut[,,1],
          widecolorgamut[,,2],
          widecolorgamut[,,3],
          widecolorgamut[,,4])
}
