% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stable_q}
\alias{stable_q}
\title{Quantile function of skew stable distributions}
\usage{
stable_q(p, pars, parametrization = 0L, tol = 1e-12)
}
\arguments{
\item{p}{Vector of points where the quantile function will be evaluated, with  0 < p[i] < 1.0}

\item{pars}{Vector with an initial estimation of the parameters. \code{pars_init = c(alpha, beta, sigma, mu)}, where
\itemize{
\item alpha: shape / stability parameter, with 0 < alpha <= 2.
\item beta: skewness parameter, with -1 <= beta <= 1.
\item sigma: scale parameter, with 0 < sigma.
\item mu: location parameter, with mu real.
}}

\item{parametrization}{Parametrization used for the skew stable distribution, as defined by JP Nolan (1997). By default, parametrization = 0.}

\item{tol}{Relative error tolerance (precission) of the calculated values. By default, tol = 1e-12.}
}
\value{
A numeric vector.
}
\description{
Evaluate the quantile function (CDF^-1) of the skew stable distribution
with parameters pars = c(alpha, beta, sigma, mu) at the points given in p.\cr\cr
\emph{parametrization} argument specifies the parametrization used for the distribution
as described by JP Nolan (1997). The default value is \emph{parametrization} = 0.\cr\cr
\emph{tol} sets the relative error tolerance (precission) to \emph{tol}. The default value is tol = 1e-12.
}
\author{
Javier Royuela del Val, Federico Simmross Wattenberg and Carlos Alberola López\cr\cr
Maintainer: Javier Royuela del Val \href{mailto:jroyval@lpi.tel.uva.es}{jroyval@lpi.tel.uva.es}
}
\keyword{distribution}
