% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_metrics.R
\name{raster_metrics}
\alias{raster_metrics}
\title{Computes metrics by aggregating a raster at lower resolution or summarizing
attributes based on XY locations}
\usage{
raster_metrics(
  r,
  res = 20,
  fun = function(x) {
     data.frame(mean = mean(x[, 3]), sd = stats::sd(x[, 3]))
 },
  start = c(0, 0),
  output = "raster"
)
}
\arguments{
\item{r}{SpatRaster object, data.frame with xy coordinates in two first columns, or POINT \code{\link[sf]{sf}} spatial object}

\item{res}{numeric. Resolution of the aggregation raster, should be a multiple
of r resolution if a raster is provided}

\item{fun}{function. Function to compute metrics in each aggregated cell from
the values contained in the initial raster (use x$layer to access raster
values) / data.frame (use x$colum_name to access values)}

\item{start}{vector of x and y coordinates for the reference raster. Default is (0,0) meaning that the grid aligns on (0,0).}

\item{output}{string. indicates the class of output object "raster" for a SpatRaster or "data.frame"}
}
\value{
a data.frame with the XY center coordinates of the aggregated cells,
and the values computed with the user-specified function, or a SpatRaster object
}
\description{
Computes statistics by aggregating a raster at lower resolution. Aggregation
groups are larger cells, new values are computed by applying a user-specified
function to original cells contained in the larger cells. Results are provided
as a data.frame with the XY coordinates of the larger cells, or as SpatRaster.
}
\examples{
data(chm_chablais3)
chm_chablais3 <- terra::rast(chm_chablais3)
# replace NA with zeros
chm_chablais3[is.na(chm_chablais3)] <- 0

# raster metrics from raster
metrics1 <- raster_metrics(chm_chablais3, res = 10)
metrics1

# raster metrics from data.frame
n <- 1000
df <- data.frame(
  x = runif(n, 0, 100), y = runif(n, 0, 100), z1 = runif(n, 0, 1),
  z2 = runif(n, 10, 20)
)
# compute raster metrics
metrics2 <- raster_metrics(df,
  res = 10,
  fun = function(x) {
    data.frame(max.z = max(x$z1), max.sum = max(x$z1 + x$z2))
  },
  output = "data.frame"
)
summary(metrics2)

# display raster metrics
terra::plot(metrics1)
# display data.frame metrics
terra::plot(terra::rast(metrics2, type = "xyz"))
}
