% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_boxcox.R
\name{gg_boxcox}
\alias{gg_boxcox}
\title{Plot boxcox graph in ggplot with suggested lambda transformation}
\usage{
gg_boxcox(fitted.lm, showlambda = TRUE, lambdaSF = 3, scale.factor = 0.5)
}
\arguments{
\item{fitted.lm}{a fitted linear model (i.e. lm, glm) that contains fitted regression}

\item{showlambda}{logical; controls whether lambda value should be displayed on graph. Defaults to TRUE}

\item{lambdaSF}{numeric; controls to how many significant figure is lambda rounded to. Defaults to 3.}

\item{scale.factor}{numeric; scales the point size and linewidth to allow customized viewing. Defaults to 0.5.}
}
\value{
A ggplot object that contains boxcox graph
}
\description{
Plot boxcox graph in ggplot with suggested lambda transformation
}
\examples{
library(MASS)
data(Cars93)
cars_lm <- lm(Price ~ Passengers + Length + RPM, data = Cars93)
gg_boxcox(cars_lm)

}
