% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getr}
\alias{getr}
\title{Calculate Time-Varying Reproduction Number R(t)}
\usage{
getr(curve, si, size)
}
\arguments{
\item{curve}{NumericVector representing the estimated epidemic curve with daily counts.
This curve can include both back-calculated and nowcasted counts of infections.}

\item{si}{NumericVector representing the serial interval distribution, expressed as a vector
where each element corresponds to the probability of a delay of that many days between
successive cases.}

\item{size}{Integer specifying the size of the moving window used to calculate the mean reproduction number.
This window size determines how many days are included in the calculation of R(t) at each step.}
}
\value{
NumericVector containing the estimated mean reproduction numbers (R(t)) for each day.
        The length of this vector will be the length of `curve` minus `size` minus one,
        reflecting the fact that the last few days do not have enough data to fill the window.
}
\description{
This function estimates the time-varying reproduction number, R(t), based on the epidemic curve and
serial interval distribution. R(t) is calculated for each day using a moving window approach,
which involves taking a segment of the epidemic curve and applying a transformation based on the
serial interval to estimate how many subsequent cases are generated by cases within the window.
}
\examples{
# Assume curve is a numeric vector of daily case counts and si is the serial interval distribution
curve <- rnorm(100, mean=10, sd=3)  # example epidemic curve
si <- rep(0.1, 10)  # example serial interval distribution
size <- 6  # example size of the moving window
getr(curve, si, size)
}
