% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{removeCustomTime}
\alias{removeCustomTime}
\title{Remove a custom time previously added}
\usage{
removeCustomTime(id, itemId)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{itemId}{The id of the custom time bar}
}
\value{
None, side-effect is Javascript call
}
\description{
Remove a custom time previously added
}
\examples{
\dontrun{
linevis() \%>\%
  addCustomTime(Sys.Date() - 1, "yesterday") \%>\%
  addCustomTime(Sys.Date() + 1, "tomorrow") \%>\%
  removeCustomTime("yesterday")
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn0", "Add custom time"),
    actionButton("btn", "Remove custom time bar")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis()
    )
    observeEvent(input$btn0, {
      addCustomTime("graph2d", Sys.Date() - 1, "yesterday")
    })
    observeEvent(input$btn, {
      removeCustomTime("graph2d", "yesterday")
    })
  }
)
}
}
