% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setOptions}
\alias{setOptions}
\title{Update the configuration options of a graph2d}
\usage{
setOptions(id, options)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{options}{A named list containing updated configuration options to use.
See the \code{options} parameter of the
\code{\link[linevis]{linevis}} function to see more details.}
}
\value{
None, side-effect is Javascript call
}
\description{
Update the configuration options of a graph2d
}
\examples{
\dontrun{
linevis(
  data.frame(start = Sys.Date(), content = "Today"),
  options = list(showCurrentTime = FALSE, orientation = "top")
) \%>\%
  setOptions(list(editable = TRUE, showCurrentTime = TRUE))
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Show current time and allow items to be editable")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis(
        data.frame(start = Sys.Date(), content = "Today"),
        options = list(showCurrentTime = FALSE, orientation = "top")
      )
    )
    observeEvent(input$btn, {
      setOptions("graph2d", list(editable = TRUE, showCurrentTime = TRUE))
    })
  }
)
}
}
