% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_lipid_names.R
\name{map_lipid_names}
\alias{map_lipid_names}
\title{Enumerate lipid names into values about lipid class, size and saturation}
\usage{
map_lipid_names(x)
}
\arguments{
\item{x}{(Required) character vector of lipid names. The names are expected
in the format 'XY(C:D)', where 'XY' is the abbreviation of the lipid
class, 'C' is the total number of carbon atoms in the fatty-acid
chains, and 'D' is the total number of double-bonds in the fatty
acid chains.}
}
\value{
Data frame with lipid names in various formats for R and
   the enumerated values of lipid class (\code{Class}), lipid size
   (\code{N.carbons}) and lipid unsaturation (\code{N.double.bonds}).
}
\description{
Use this function to create a mapping of the lipids to values, which can be
   used to creating 'lipidomeR' heatmaps.
}
\seealso{
\code{\link{heatmap_lipidome_from_limma}} for creating 'lipidomeR'
   heatmaps of regression model results based on the output of this function.

\code{\link{heatmap_lipidome}} for creating 'lipidomeR' heatmaps
   of any lipid-specific values based on the output of this function.
}
