% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_env_subset.R
\name{parse_env_subset}
\alias{parse_env_subset}
\title{Helper function to infer target from expression and environment}
\usage{
parse_env_subset(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  is_variable = TRUE
)
}
\arguments{
\item{expr}{An expression.}

\item{envir}{An environment.}

\item{substitute}{If \code{TRUE}, then the expression is \code{\link[base:substitute]{base::substitute()}}:ed,
otherwise not.}

\item{is_variable}{(logical) If TRUE and an element name is specified, then
the name is checked to be a valid variable name.}
}
\value{
A named list with elements:
\describe{
\item{\code{envir}}{An environment (defaults to argument \code{envir})}
\item{\code{name}}{A character vector. ...}
\item{\code{op}}{...}
\item{\code{subset}}{A list of \code{NULL}. ...}
\item{\code{idx}}{An integer vector or \code{NULL}. ...}
\item{\code{exists}}{A logical vector of length \code{length(idx)} with \code{TRUE}
and \code{FALSE} values.}
\item{\code{code}}{The deparsed expression \code{expr} coerced to a single character
string.}
}
}
\description{
Helper function to infer target from expression and environment
}
\keyword{internal}
