% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim-fxns.R
\name{fit_litter}
\alias{fit_litter}
\title{Fit different models to single cohort decomposition data}
\usage{
fit_litter(
  time,
  mass.remaining,
  model = c("neg.exp", "weibull", "discrete.parallel", "discrete.series", "cont.quality",
    "neg.exp.limit"),
  iters = 500,
  upper = NULL,
  lower = NULL,
  ...
)
}
\arguments{
\item{time}{time since decomposition began, that is, ti-t0}

\item{mass.remaining}{proportional mass loss, that is, mi/m0}

\item{model}{there are five models currently implemented (see below)}

\item{iters}{Number of random starts for the fitting.  Use higher numbers for models with larger numbers of parameters and for models that inherently tend to be less identifiable.}

\item{upper, lower}{\bold{Optional} user specified values for the upper and lower bounds used by
\code{optim} in the fitting procedure. Use with care, only minimal sanity checking is currently
implemented.}

\item{...}{Additional arguments passed to \code{\link{optim}}}
}
\value{
returns a litfit object with the following elements:
\itemize{
\item{\bold{optimFit:} a list generated by the \code{\link{optim}} function}
\item{\bold{logLik:} the log-likelihood of the model}
\item{\bold{time:} vector of time (same as input)}
\item{\bold{mass:} vector os mass remaining (same as input)}
\item{\bold{predicted:} predicted values from the model for each of the points within time}
\item{\bold{model:} name of the model }
\item{\bold{nparams:} number of fit parameters in the model}
\item{\bold{AIC:} AIC of the model fit}
\item{\bold{AICc:} AICc of the model fit}
\item{\bold{BIC:} BIC of the model fit}
\item{and some other potentially useful things}
}
}
\description{
Non-linear fits of different models to the decomposition trajectory
of one cohort (as in typical litterbag studies) data.
Models range from very simple (and easy to fit with limited data)
to more complex.
}
\details{
the model likelihood is maximized using methods available in \code{\link[stats]{optim}}.  Optimization methods to be used within optim can be specified through the control object (i.e., control$method).  The default method is L-BFGS-B with bounds specific to each model. Each model
\itemize{
\item{\bold{weibull} The Weibull residence time model--two parameters (Frechet 1927)}
\item{\bold{discrete.parallel} Two pools in parallel with a term for the fraction of initial mass in each pool--three parameter (Manzoni et al. 2012)}
\item{\bold{discrete.series} A three parameter model in which there is the possibility of two sequential pools (Manzoni et al. 2012)}
\item{\bold{cont.quality} (Ågren and Bosatta 1996, see also Manzoni et al. 2012)}
}
\emph{Warning}: difficulty in finding the optimal solution is determined by an interaction between the nature and complexity of the
likelihood space (which is both data- and model-dependent) as well as the optimization methods.  There is can never be a guarantee that the optimal solution is found, but using many random starting points will increase these odds.  It should be noted that there is significant variation among models in identifiability, with some models inherently less identifiable likely due to a tendency to form for flat ridges in likelihood space.  The confidence in the fit should be very low in these cases (see Cornwell and Weedon 2013).   A number of random starting points are used in optimization and are given through the iters.  The function checks whether the the top 10 optimizations have converged on the same likelihood, and if they have not this function will return a warning.
}
\examples{
data(pineneedles)
fit<-fit_litter(time=pineneedles$Year,mass.remaining=pineneedles$Mass.remaining,
model='neg.exp',iters=1000)
}
\references{
\itemize{ \item{Ågren, G. and Bosatta, E. (1996) Quality: a bridge between theory and experiment in soil organic matter studies. Oikos, 76, 522–528.}
\item{Cornwell, W. K., and J. T. Weedon. (2013).  Decomposition trajectories of diverse litter types: a model selection analysis. Methods in Ecology and Evolution.}
\item{Frechet, M. (1927) Sur la loi de probabilite de lecart maximum. Ann de la Soc polonaise de Math, 6, 93–116.}
\item{Manzoni, S., Pineiro, G., Jackson, R. B., Jobbagy, E. G., Kim, J. H., & Porporato, A. (2012). Analytical models of soil and litter decomposition: Solutions for mass loss and time-dependent decay rates. Soil Biology and Biochemistry, 50, 66-76.}
\item{Olson, J.S. (1963) Energy storage and the balance of producers and decomposers in ecological systems. Ecology, 44, 322–331.}}
}
\seealso{
\code{\link{optim}},
\code{\link{steady_state}},
\code{\link{plot.litfit}}
}
\author{
Will Cornwell and James Weedon
}
