% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.clpca.R
\name{plot.clpca}
\alias{plot.clpca}
\title{Plots a Cumulative Logistic PCA model}
\usage{
\method{plot}{clpca}(
  x,
  dims = c(1, 2),
  ycol = "darkgreen",
  xcol = "darkblue",
  ocol = "grey",
  markersize = 2.5,
  labelsize = 3,
  ...
)
}
\arguments{
\item{x}{an object of type clpca}

\item{dims}{which dimensions to visualize}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{markersize}{size of points}

\item{labelsize}{size of labels}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from clpca
}
\description{
Plots a Cumulative Logistic PCA model
}
\examples{
\dontrun{
data(dataExample_clpca)
Y<-as.matrix(dataExample_clpca[,5:8])
X<-as.matrix(dataExample_clpca[,1:4])
out = clpca(Y, X)
plot(out)
}

}
