% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abdom.R
\name{abdom}
\alias{abdom}
\title{Abdominal circumference data}
\format{
This data frame contains the following columns:

\describe{
\item{y}{Abdominal circumference: a numeric vector.}
\item{x}{Gestational age: a numeric vector.}
}
}
\source{
Dr. Eileen M. Wright, Department of Medical Statistics and Evaluation,
Royal Postgraduate Medical School, Du Cane Road, London, W12 0NN.

The \code{abdom} dataset was copied into the \code{lmls} package from the
\code{gamlss.data} package. \code{gamlss.data} is licensed under the GPL 2 and 3.
}
\usage{
data(abdom)
}
\description{
The \code{abdom} data frame has 610 rows and 2 columns. The data are
measurements of abdominal circumference (response variable) taken from
fetuses during ultrasound scans at Kings College Hospital, London, at
gestational ages (explanatory variable) ranging between 12 and 42 weeks.
}
\details{
The data were used to derive reference intervals by Chitty \emph{et al.}
(1994) and also for comparing different reference centile methods by
Wright and Royston (1997), who also commented that the distribution of
z-scores obtained from the different fitted models "has somewhat longer
tails than the normal distribution".
}
\examples{
data(abdom)
attach(abdom)
plot(x, y)
detach(abdom)
}
\references{
Chitty, L.S., Altman, D.G., Henderson, A. and Campbell, S. (1994). Charts
of fetal size: 3, abdominal measurement. \emph{Br. J. Obstet. Gynaec.},
\strong{101}: 125–131.

Wright, E.M. and Royston, P. (1997). A comparison of statistical
methods for age-related reference intervals. \emph{J. R. Statist. Soc. A.},
\strong{160}: 47–69.
}
