% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_lscore.R
\name{print.lscore}
\alias{print.lscore}
\title{Print Summary of Load Shape Score}
\usage{
\method{print}{lscore}(x, ... = NULL)
}
\arguments{
\item{x}{An object of class \code{lscore},
created by the function \code{\link{lscore}}.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
\code{NULL}. Prints the summary of the load shape score.
}
\description{
Print Summary of Load Shape Score
}
\note{
Same as \code{\link{summary.lscore}}
}
\examples{
loads <- ercot[ercot$Year == 2019, ]$SOUTH
# --------------
log_loadshape <- lslog(loads, target_lf = 0.5)
print(lscore(log_loadshape, type = "acf"))
print(lscore(log_loadshape, type = "pacf"))
# --------------
lin_loadshape <- lslin(loads, target_lf = 0.5)
print(lscore(lin_loadshape, type = "acf"))
print(lscore(lin_loadshape, type = "pacf"))







}
\seealso{
\code{\link{lslin}}, \code{\link{lscore}},
\code{\link{lscore}}
}
