% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{intercoder_reliability}
\alias{intercoder_reliability}
\title{Intercoder reliability for LLM annotations}
\usage{
intercoder_reliability(
  annotations,
  method = c("auto", "cohen", "krippendorff"),
  label_levels = NULL,
  sample_col = "sample_id",
  model_col = "model_id",
  label_col = "label"
)
}
\arguments{
\item{annotations}{Output from [explore()] or a compatible data
frame with at least `sample_id`, `model_id`, and `label` columns.}

\item{method}{One of `"auto"`, `"cohen"`, or `"krippendorff"`. The `"auto"`
setting computes both pairwise Cohen's Kappa and Krippendorff's Alpha (when
applicable).}

\item{label_levels}{Optional factor levels to enforce a consistent ordering
in the resulting tables.}

\item{sample_col}{Column name that identifies samples when `annotations` is a
user-provided data frame.}

\item{model_col}{Column name for the model identifier when using a custom
`annotations` data frame.}

\item{label_col}{Column name containing model predictions when using a custom
`annotations` data frame.}
}
\value{
A list containing `cohen` (data frame of pairwise kappas) and/or
  `krippendorff` (overall alpha statistic with per-item agreement scores).
}
\description{
Intercoder reliability for LLM annotations
}
