% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clmi.R
\name{clmi}
\alias{clmi}
\title{Censored Likelihood Multiple Imputation}
\usage{
clmi(formula, df, lod, seed, n.imps = 5, verbose = FALSE)
}
\arguments{
\item{formula}{A formula in the form of \code{exposure ~ outcome + covariates}.
That is, the first variable on the right hand side of \code{formula} should
be the outcome of interest.}

\item{df}{A data.frame with \code{exposure}, \code{outcome} and
\code{covariates}.}

\item{lod}{Name of limit of detection variable in \code{df}.}

\item{seed}{For reproducability.}

\item{n.imps}{Number of datasets to impute. Default is 5.}

\item{verbose}{If \code{TRUE}, \code{clmi} prints out useful debugging
information while running. Default is \code{FALSE}.}
}
\description{
This function performs censored likelihood multiple imputation for
single-pollutant models where the pollutant of interest is subject to
varying detection limits across batches (this function will also work if
there is only one distinct detection limit). The function
outputs a list containing the imputed datasets and details regarding the
imputation procedure (i.e., number of imputed dataset, covariates used to
impute the non-detects, etc).
}
\details{
\code{clmi} is somewhat picky regarding the \code{formula} parameter. It
tries to infer what transformation you'd like to apply to the exposure you
are imputing, what the exposure is, and what the outcome is. It attempts to
check to make sure that everything is working correctly, but it can fail.
Roughly, the rules are:
\itemize{
  \item The left hand side of formula should be the exposure you are trying
    to impute.
  \item The exposure may be optionally wrapped in a univariate transformation
    function. If the transformation function is not univariate, you ought to
    get an error about a "complicated" transformation.
  \item The first variable on the right hand side of \code{formula} should be
    your outcome of interest.
}
}
\note{
\itemize{
  \item \code{clmi} only supports categorical variables that are numeric,
    (i.e., not factors or characters). You can use the \code{model.matrix}
    function to convert a data frame with factors to a numeric design matrix
    and subsequently convert that matrix back into a data frame using
    \code{as.data.frame}.
  \item If you get the error message "L-BFGS-B needs finite values of 'fn'",
    try normalising your data.
}
}
\examples{
library(lodi)

# Note that the outcome of interest is the first variable on the right hand
# side of the formula.
clmi.out <- clmi(poll ~ case_cntrl + smoking + gender, toy_data, lod, 1)

# you can specify a transformation to the exposure in the formula
clmi.out <- clmi(log(poll) ~ case_cntrl + smoking + gender, toy_data, lod, 1)

}
\references{
Boss J, Mukherjee B, Ferguson KK, et al. Estimating outcome-exposure
  associations when exposure biomarker detection limits vary across batches.
  Epidemiology. 2019;30(5):746-755.
  \href{https://doi.org/10.1097/EDE.0000000000001052}{10.1097/EDE.0000000000001052}
}
