% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/login_server.R
\name{login_server}
\alias{login_server}
\title{Login server module.}
\usage{
login_server(
  id,
  db_conn = NULL,
  users_table = "users",
  activity_table = "users_activity",
  emailer = NULL,
  new_account_subject = "Verify your new account",
  reset_password_subject = "Reset password",
  verify_email = !is.null(emailer),
  additional_fields = NULL,
  cookie_name = "loginusername",
  cookie_expiration = 30,
  username_label = "Email:",
  password_label = "Password:",
  create_account_label = "Create Account",
  create_account_message = NULL,
  reset_email_message = NULL,
  enclosing_panel = shiny::wellPanel,
  code_length = 6,
  salt = NULL,
  salt_algo = "sha512",
  shinybusy_spin = "fading-circle",
  shinybusy_position = "full-page"
)
}
\arguments{
\item{id}{unique ID for the Shiny Login module.}

\item{db_conn}{a DBI database connection.}

\item{users_table}{the name of the table in the database to store credentials.}

\item{activity_table}{the name of the table in the database to log login and
logout activity.}

\item{emailer}{function used to send email messages. The function should have
have three parameters: \code{to_email} for the address to send the email,
\code{subject} for the subject of the email and \code{message} for the contents
of the email address. See \code{\link[=emayili_emailer]{emayili_emailer()}} for an example.}

\item{new_account_subject}{the subject used for verifying new accounts.}

\item{reset_password_subject}{the subject of password reset emails.}

\item{verify_email}{if true new accounts will need to verify their email
address before the account is crated. This is done by sending a six
digit code to the email address.}

\item{additional_fields}{a character vector of additional fields the user is
asked to fill in at the when creating a new account. The names of the
vector correspond to the variable names and the values will be used
as the input labels.}

\item{cookie_name}{the name of the cookie saved. Set to \code{NULL} to disable cookies.}

\item{cookie_expiration}{the number of days after which the cookie will expire.}

\item{username_label}{label used for text inputs of username.}

\item{password_label}{label used for text inputs of password.}

\item{create_account_label}{label for the create account button.}

\item{create_account_message}{Email message sent to confirm email when creating
a new account. Include \verb{\\\%s} somewhere in the message to include the code.}

\item{reset_email_message}{Email message sent to reset password. Include \verb{\\\%s}
somewhere in the message to include the code.}

\item{enclosing_panel}{the Shiny element that contains all the UI elements.
The default is \code{\link[shiny:wellPanel]{shiny::wellPanel()}}. If you wish a more subtle appearance
\code{\link[htmltools:builder]{htmltools::div()}} is a reasonable choice.}

\item{code_length}{the number of digits of codes emailed for creating accounts
(if \code{verify_email == TRUE}) or resetting passwords.}

\item{salt}{a salt to use to encrypt the password before storing it in the database.}

\item{salt_algo}{the algorithm used to encrypt the password. See
\code{\link[digest:digest]{digest::digest()}} for more details.}

\item{shinybusy_spin}{Style of the spinner when sending emails.
See \code{\link[shinybusy:manual-spinner]{shinybusy::use_busy_spinner()}} for more information.}

\item{shinybusy_position}{Position of the spinner when sending emails.
See \code{\link[shinybusy:manual-spinner]{shinybusy::use_busy_spinner()}} for more information.}
}
\value{
a \code{\link[shiny:reactiveValues]{shiny::reactiveValues()}} object that includes two values: \code{logged_in}
(this is TRUE if the user is logged in) and \code{username} which has the
user's login username if logged in.
}
\description{
This is the main server logic for the \code{login} Shiny module to be included
in server.R side,.
}
\examples{
library(shiny)
library(login)

###### User Interface ##########################################################
ui <- fluidPage(
    titlePanel("Shiny Login Simple Demo"),
    p("You can login with 'test/test'."),
    login::login_ui(id = 'login_demo'),
    login::logout_button('login_demo'),
    hr(),
    div('Are you logged in? ', textOutput('is_logged_in')),
    div('Username: ', textOutput('username')),
    login::is_logged_in(
        id = 'login_demo',
        div("This only shows when you are logged in!")
    ),
    login::is_not_logged_in(
        id = 'login_demo',
        div("This only shows when you are NOT logged in!")
    )
)

##### Server ###################################################################
server <- function(input, output, session) {
    USER <- login::login_server(
        id = 'login_demo',
        db_conn = RSQLite::dbConnect(RSQLite::SQLite(), 'users.sqlite')
    )

    observeEvent(USER$logged_in, {
        if(USER$logged_in) {
            shinyjs::hide(id = 'login_box')
        } else {
            shinyjs::show(id = "login_box")
        }
    })

    output$is_logged_in <- renderText({
        USER$logged_in
    })

    output$username <- renderText({
        USER$username
    })
}

##### Run the application ######################################################
if(interactive()) {
    shinyApp(ui = ui, server = server)
}
}
