% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{log_config}
\alias{log_config}
\title{Configuration of the log.rx environment}
\usage{
log_config(file = NA, log_name = NA, log_path = NA, extra_info = NA)
}
\arguments{
\item{file}{String. Path to file executed. Optional}

\item{log_name}{String. Name of log file. Optional}

\item{log_path}{String. Path to log file. Optional}

\item{extra_info}{List. Objects to add on to end of log
in a special extra info section. Optional}
}
\value{
Nothing
}
\description{
\code{log_config()} initialises the log.rx environment, adds its attributes, and
sets them
}
\examples{
dir <- tempdir()
text <- 'print("Hello, Timberperson!")'
fileConn <- file(file.path(dir, "hello.R"))
writeLines(text, fileConn)
close(fileConn)

file <- file.path(dir, "hello.R")

# Initialise and configure the log.rx environment
log_config(file)

# Run the script and record results, outputs, messages, errors, and warnings
logrx:::run_safely_loudly(file)

# Write the log
log_write(file)
}
