% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline.R, R/roxygen.R
\name{inlineLologPlugin}
\alias{inlineLologPlugin}
\title{An lolog plug-in for easy C++ prototyping and access}
\usage{
inlineLologPlugin(...)

inlineLologPlugin
}
\arguments{
\item{...}{plug-in arguments}
}
\description{
An lolog plug-in for easy C++ prototyping and access

The inline plug-in for lolog
}
\details{
The lolog Rcpp plugin allows for the rapid prototyping of compiled code.
new functions can be registered and exposed using \code{\link[Rcpp]{cppFunction}}
and new statistics can be compiled and registered using \code{\link[Rcpp]{sourceCpp}}.
}
\examples{
\dontrun{
# This creates a function in C++ to create an empty network of size n
# and expose it to R.
src <- "
lolog::BinaryNet<lolog::Directed> makeEmptyNetwork(const int n){
Rcpp::IntegerMatrix tmp(0,2);
lolog::BinaryNet<lolog::Directed> net(tmp, n);
return net;
}
"
Rcpp::registerPlugin("lolog",inlineLologPlugin)
emptyNetwork <- cppFunction(src,plugin="lolog")
net <- emptyNetwork(10L)
net[1:10,1:10]

}
}
\seealso{
\code{\link[Rcpp]{cppFunction}}, \code{\link[Rcpp]{sourceCpp}}
}
